% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R, R/setters.R
\name{sh_month}
\alias{sh_month}
\alias{sh_month.jdate}
\alias{sh_month.jdatetime}
\alias{sh_month<-}
\alias{sh_month<-.jdate}
\alias{sh_month<-.jdatetime}
\title{Get/set the month component of Jalali date-time objects}
\usage{
sh_month(x)

\method{sh_month}{jdate}(x)

\method{sh_month}{jdatetime}(x)

sh_month(x) <- value

\method{sh_month}{jdate}(x) <- value

\method{sh_month}{jdatetime}(x) <- value
}
\arguments{
\item{x}{A vector of \code{jdate} or \code{jdatetime} objects.}

\item{value}{A numeric vector.}
}
\value{
The month component of x as an integer.
}
\description{
Get/set the month component of Jalali date-time objects
}
\details{
For assignment, \code{x} and \code{value} are recycled to their common size using
\link[vctrs:theory-faq-recycling]{tidyverse recycling rules}.
}
\examples{
x <- jdate("1402-12-14")
sh_month(x)
sh_month(x) <- 10:11
}
