% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/widgets.R
\name{flex_container}
\alias{flex_container}
\alias{flex_item}
\title{Generate 'HTML' tags with 'flex' layout}
\usage{
flex_container(
  ...,
  style = NULL,
  direction = c("row", "column"),
  wrap = c("wrap", "nowrap", "wrap-reverse"),
  justify = c("flex-start", "center", "flex-end", "space-around", "space-between"),
  align_box = c("stretch", "flex-start", "center", "flex-end", "baseline"),
  align_content = c("stretch", "flex-start", "flex-end", "space-between",
    "space-around", "center")
)

flex_item(
  ...,
  style = NULL,
  order = NULL,
  flex = "1",
  align = c("flex-start", "flex-end", "center")
)
}
\arguments{
\item{...}{for \code{flex_container}, it's elements of \code{flex_item};
for \code{flex_item}, \code{...} are shiny 'HTML' tags}

\item{style}{the additional 'CSS' style for containers or inner items}

\item{direction, wrap, justify, align_box, align_content}{'CSS' styles for
'flex' containers}

\item{order, align, flex}{CSS' styles for 'flex' items}
}
\value{
'HTML' tags
}
\description{
Generate 'HTML' tags with 'flex' layout
}
\examples{

x <- flex_container(
  style = "position:absolute;height:100vh;top:0;left:0;width:100\%",
  flex_item(style = 'background-color:black;'),
  flex_item(style = 'background-color:red;')
)
# You can view it via `htmltools::html_print(x)`

}
