% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutationProfiling.R
\name{calcExpectedMutations}
\alias{calcExpectedMutations}
\title{Calculate expected mutation frequencies of a sequence}
\usage{
calcExpectedMutations(germlineSeq, inputSeq = NULL, targetingModel = HH_S5F,
  regionDefinition = NULL, mutationDefinition = NULL)
}
\arguments{
\item{germlineSeq}{germline (reference) sequence.}

\item{inputSeq}{input (observed) sequence. If this is not \code{NULL}, 
then \code{germlineSeq} will be processed to be the same
same length as \code{inputSeq} and positions in 
\code{germlineSeq} corresponding to positions with Ns in 
\code{inputSeq} will also be assigned an N.}

\item{targetingModel}{\link{TargetingModel} object. Default is \link{HH_S5F}.}

\item{regionDefinition}{\link{RegionDefinition} object defining the regions
and boundaries of the Ig sequences.}

\item{mutationDefinition}{\link{MutationDefinition} object defining replacement
and silent mutation criteria. If \code{NULL} then 
replacement and silent are determined by exact 
amino acid identity.}
}
\value{
A \code{numeric} vector of the expected frequencies of mutations in the 
          regions in the \code{regionDefinition}. For example, when using the default 
          \link{IMGT_V} definition, which defines positions for CDR and 
          FWR, the following columns are calculated:
          \itemize{
             \item  \code{MU_EXPECTED_CDR_R}:  number of replacement mutations in CDR1 and 
                                            CDR2 of the V-segment.
             \item  \code{MU_EXPECTED_CDR_S}:  number of silent mutations in CDR1 and CDR2 
                                            of the V-segment.
             \item  \code{MU_EXPECTED_FWR_R}:  number of replacement mutations in FWR1, 
                                            FWR2 and FWR3 of the V-segment.
             \item  \code{MU_EXPECTED_FWR_S}:  number of silent mutations in FWR1, FWR2 and
                                            FWR3 of the V-segment.
           }
}
\description{
\code{calcExpectedMutations} calculates the expected mutation
frequencies of a given sequence. This is primarily a helper function for
\link{expectedMutations}.
}
\details{
\code{calcExpectedMutations} calculates the expected mutation frequencies of a 
given sequence and its germline. 

Note, only the part of the sequences defined in \code{regionDefinition} are analyzed. 
For example, when using the default \link{IMGT_V} definition, mutations in
positions beyond 312 will be ignored.
}
\examples{
# Load example data
data(ExampleDb, package="alakazam")

# Use first entry in the exampled data for input and germline sequence
in_seq <- ExampleDb[["SEQUENCE_IMGT"]][1]
germ_seq <-  ExampleDb[["GERMLINE_IMGT_D_MASK"]][1]

# Identify all mutations in the sequence
calcExpectedMutations(in_seq, germ_seq)

# Identify only mutations the V segment minus CDR3
calcExpectedMutations(in_seq, germ_seq, regionDefinition=IMGT_V)

# Define mutations based on hydropathy
calcExpectedMutations(in_seq, germ_seq, regionDefinition=IMGT_V,
                      mutationDefinition=HYDROPATHY_MUTATIONS)

}
\seealso{
\link{expectedMutations} calls this function.
To create a custom \code{targetingModel} see \link{createTargetingModel}.
See \link{calcObservedMutations} for getting observed mutation counts.
}
