% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistToNearest.R
\docType{class}
\name{GmmThreshold-class}
\alias{GmmThreshold-class}
\alias{GmmThreshold}
\alias{print,GmmThreshold-method}
\alias{GmmThreshold-method}
\alias{plot,GmmThreshold,missing-method}
\alias{GmmThreshold-method}
\title{Output of the \code{gmm} method of findThreshold}
\usage{
\S4method{print}{GmmThreshold}(x)

\S4method{plot}{GmmThreshold,missing}(x, y, ...)
}
\arguments{
\item{x}{GmmThreshold object}

\item{y}{ignored.}

\item{...}{arguments to pass to \link{plotGmmThreshold}.}
}
\description{
\code{GmmThreshold} contains output from the \code{gmm} method \link{findThreshold}. 
It includes parameters of two Gaussian fits and threshold cut.
}
\section{Slots}{

\describe{
\item{\code{x}}{input distance vector with NA or infinite values removed.}

\item{\code{model}}{first-second fit functions.}

\item{\code{cutoff}}{type of threshold cut.}

\item{\code{a1}}{mixing weight of the first curve.}

\item{\code{b1}}{second parameter of the first curve. Either the mean of a Normal 
distribution or shape of a Gamma distribution.}

\item{\code{c1}}{third parameter of the first curve. Either the standard deviation of a 
Normal distribution or scale of a Gamma distribution.}

\item{\code{a2}}{mixing weight of the second curve.}

\item{\code{b2}}{second parameter of the second curve. Either the mean of a Normal 
distribution or shape of a Gamma distribution.}

\item{\code{c2}}{third parameter of the second curve. Either the standard deviation 
of a Normal distribution or scale of a Gamma distribution.}

\item{\code{loglk}}{log-likelihood of the fit.}

\item{\code{threshold}}{threshold.}

\item{\code{sensitivity}}{sensitivity.}

\item{\code{specificity}}{specificity.}

\item{\code{pvalue}}{p-value from Hartigans' dip statistic (HDS) test. 
Values less than 0.05 indicate significant bimodality.}
}}

\seealso{
\link{findThreshold}
}
