% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{extendMutabilityMatrix}
\alias{extendMutabilityMatrix}
\title{Extends a mutability model to include Ns.}
\usage{
extendMutabilityMatrix(mutabilityModel)
}
\arguments{
\item{mutabilityModel}{vector of 5-mer mutability rates built by 
\link{createMutabilityMatrix}.}
}
\value{
A 3125 vector of normalized mutability rates for each 5-mer motif with 
          names defining the 5-mer nucleotide sequence.
}
\description{
\code{extendMutabilityMatrix} extends a 5-mer nucleotide mutability model 
with 5-mers that include Ns by averaging over all corresponding 5-mers without Ns.
}
\examples{
# Subset example data to one isotype and sample as a demo
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, ISOTYPE == "IgA" & SAMPLE == "-1h")

# Create model using only silent mutations and ignore multiple mutations
sub_model <- createSubstitutionMatrix(db, model="S")
mut_model <- createMutabilityMatrix(db, sub_model, model="S")
ext_model <- extendMutabilityMatrix(mut_model)

}
\seealso{
\link{createMutabilityMatrix}, \link{extendSubstitutionMatrix}
}

