% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection_performance.R
\name{SelectionPerformance}
\alias{SelectionPerformance}
\title{Selection performance}
\usage{
SelectionPerformance(theta, theta_star, pk = NULL, cor = NULL, thr = 0.5)
}
\arguments{
\item{theta}{output from \code{\link{VariableSelection}},
\code{\link{BiSelection}}, or \code{\link{GraphicalModel}}. Alternatively,
it can be a binary matrix of selected variables (in variable selection) or
a binary adjacency matrix (in graphical modelling)}

\item{theta_star}{output from \code{\link{SimulateRegression}},
\code{\link{SimulateComponents}}, or \code{\link{SimulateGraphical}}.
Alternatively, it can be a binary matrix of true predictors (in variable
selection) or the true binary adjacency matrix (in graphical modelling).}

\item{pk}{optional vector encoding the grouping structure. Only used for
multi-block stability selection where \code{pk} indicates the number of
variables in each group. If \code{pk=NULL}, single-block stability
selection is performed.}

\item{cor}{optional correlation matrix. Only used in graphical modelling.}

\item{thr}{optional threshold in correlation. Only used in graphical
modelling and when argument "cor" is not NULL.}
}
\value{
A matrix of selection metrics including:

  \item{TP}{number of True Positives (TP)} \item{FN}{number of False
  Negatives (TN)} \item{FP}{number of False Positives (FP)} \item{TN}{number
  of True Negatives (TN)} \item{sensitivity}{sensitivity, i.e. TP/(TP+FN)}
  \item{specificity}{specificity, i.e. TN/(TN+FP)} \item{accuracy}{accuracy,
  i.e. (TP+TN)/(TP+TN+FP+FN)} \item{precision}{precision (p), i.e.
  TP/(TP+FP)} \item{recall}{recall (r), i.e. TP/(TP+FN)}
  \item{F1_score}{F1-score, i.e. 2*p*r/(p+r)}

  If argument "cor" is provided, the number of False Positives among
  correlated (FP_c) and uncorrelated (FP_i) pairs, defined as having
  correlations (provided in "cor") above or below the threshold "thr", are
  also reported.

  Block-specific performances are reported if "pk" is not NULL. In this case,
  the first row of the matrix corresponds to the overall performances, and
  subsequent rows correspond to each of the blocks. The order of the blocks
  is defined as in \code{\link{BlockStructure}}.
}
\description{
Computes different metrics of selection performance by comparing the set of
selected features to the set of true predictors/edges. This function can only
be used in simulation studies (i.e. when the true model is known).
}
\examples{
\donttest{
# Variable selection model
set.seed(1)
simul <- SimulateRegression(pk = 30, nu_xy = 0.5)
stab <- VariableSelection(xdata = simul$xdata, ydata = simul$ydata)

# Selection performance
SelectionPerformance(theta = stab, theta_star = simul)

# Alternative formulation
SelectionPerformance(
  theta = SelectedVariables(stab),
  theta_star = simul$theta
)
}

}
\seealso{
Other functions for model performance: 
\code{\link{ClusteringPerformance}()},
\code{\link{SelectionPerformanceGraph}()}
}
\concept{functions for model performance}
