% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms.R
\name{GraphicalAlgo}
\alias{GraphicalAlgo}
\title{Graphical model algorithm}
\usage{
GraphicalAlgo(
  xdata,
  pk = NULL,
  Lambda,
  Sequential_template = NULL,
  scale = TRUE,
  implementation = PenalisedGraphical,
  start = "cold",
  ...
)
}
\arguments{
\item{xdata}{matrix with observations as rows and variables as columns.}

\item{pk}{optional vector encoding the grouping structure. Only used for
multi-block stability selection where \code{pk} indicates the number of
variables in each group. If \code{pk=NULL}, single-block stability
selection is performed.}

\item{Lambda}{matrix of parameters controlling the level of sparsity in the
underlying feature selection algorithm specified in \code{implementation}.
If \code{Lambda=NULL} and \code{implementation=PenalisedGraphical},
\code{\link{LambdaGridGraphical}} is used to define a relevant grid.
\code{Lambda} can be provided as a vector or a matrix with
\code{length(pk)} columns.}

\item{Sequential_template}{logical matrix encoding the type of procedure to
use for data with multiple blocks in stability selection graphical
modelling. For multi-block estimation, the stability selection model is
constructed as the union of block-specific stable edges estimated while the
others are weakly penalised (\code{TRUE} only for the block currently being
calibrated and \code{FALSE} for other blocks). Other approaches with joint
calibration of the blocks are allowed (all entries are set to \code{TRUE}).}

\item{scale}{logical indicating if the correlation (\code{scale=TRUE}) or
covariance (\code{scale=FALSE}) matrix should be used as input of
\code{\link[glassoFast]{glassoFast}} if
\code{implementation=PenalisedGraphical}. Otherwise, this argument must be
used in the function provided in \code{implementation}.}

\item{implementation}{function to use for graphical modelling. If
\code{implementation=PenalisedGraphical}, the algorithm implemented in
\code{\link[glassoFast]{glassoFast}} is used for regularised estimation of
a conditional independence graph. Alternatively, a user-defined function
can be provided.}

\item{start}{character string indicating if the algorithm should be
initialised at the estimated (inverse) covariance with previous penalty
parameters (\code{start="warm"}) or not (\code{start="cold"}). Using
\code{start="warm"} can speed-up the computations, but could lead to
convergence issues (in particular with small \code{Lambda_cardinal}). Only
used for \code{implementation=PenalisedGraphical} (see argument
\code{"start"} in \code{\link[glassoFast]{glassoFast}}).}

\item{...}{additional parameters passed to the function provided in
\code{implementation}.}
}
\value{
An array with binary and symmetric adjacency matrices along the third
  dimension.
}
\description{
Runs the algorithm specified in the argument \code{implementation} and
returns the estimated adjacency matrix. This function is not using stability.
}
\details{
The use of the procedure from Equation (4) or (5) is controlled by
  the argument "Sequential_template".
}
\examples{
# Data simulation
set.seed(1)
simul <- SimulateGraphical()

# Running graphical LASSO
myglasso <- GraphicalAlgo(
  xdata = simul$data,
  Lambda = cbind(c(0.1, 0.2))
)
}
\seealso{
\code{\link{GraphicalModel}}, \code{\link{PenalisedGraphical}}

Other wrapping functions: 
\code{\link{SelectionAlgo}()}
}
\concept{wrapping functions}
