% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{is.mshapviz}
\alias{is.mshapviz}
\title{Check for mshapviz}
\usage{
is.mshapviz(object)
}
\arguments{
\item{object}{An R object.}
}
\value{
Returns \code{TRUE} if \code{object} has "mshapviz" among its classes,
and \code{FALSE} otherwise.
}
\description{
Is object of class "mshapviz"?
}
\examples{
S <- matrix(c(1, -1, -1, 1), ncol = 2, dimnames = list(NULL, c("x", "y")))
X <- data.frame(x = c("a", "b"), y = c(100, 10))
s1 <- shapviz(S, X, baseline = 4)[1]
s2 <- shapviz(S, X, baseline = 4)
x <- c(s1 = s1, s2 = s2)
is.mshapviz(x)
is.mshapviz(s1)
}
\seealso{
\code{\link[=mshapviz]{mshapviz()}}
}
