% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shallot.R
\name{permutation}
\alias{permutation}
\alias{print.shallot.permutation}
\title{Permutation}
\usage{
permutation(..., n.items = NULL, fixed = TRUE)

\method{print}{shallot.permutation}(x, ...)
}
\arguments{
\item{...}{For the function \code{\link{permutation}}, a permutation of the
integers \code{1}, \code{2},... \code{n}, where \code{n} is the length of
the vector.  For the function \code{\link{print.shallot.permutation}}, this
is ignored.}

\item{n.items}{An optional argument provided instead of \code{...} to
request a random partition.  The argument \code{fixed} must be \code{FALSE}.}

\item{fixed}{Should the permutation be fixed?}

\item{x}{An object of class \code{shallot.permutation}.}
}
\value{
An object of class \code{shallot.permutation}.
}
\description{
These function define a permutation for subsequent use.
}
\details{
A valid permutation of length \code{n} is an integer vector of length
\code{n} containing each integer \code{1}, \code{2},... \code{n} only once.
}
\examples{

## Demonstrate permutation.
permutation(c(3, 1, 2, 5, 4))
permutation(c(3, 1, 2, 5, 4), fixed=FALSE)
permutation(n.items=5, fixed=FALSE)

}
\references{
\href{https://doi.org/10.1080/01621459.2016.1165103}{Dahl, D. B.,
Day, R., and Tsai, J. (2017), Random Partition Distribution Indexed by
Pairwise Information, \emph{Journal of the American Statistical
Association}, 112, 721-732. <DOI:10.1080/01621459.2016.1165103>}
}
\seealso{
\code{\link{attraction}}
}
\author{
David B. Dahl \email{dahl@stat.byu.edu}
}
