% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgo_laea.R
\encoding{UTF-8}
\name{sgo_laea_etrs}
\alias{sgo_laea_etrs}
\title{ETRS89-LAEA Easting/Northing to ETRS89 geodetic coordinates}
\usage{
sgo_laea_etrs(x)
}
\arguments{
\item{x}{A \code{sgo_points} object describing a set of points in the
projected coordinate system EPSG=3035.}
}
\value{
An object of class \code{sgo_points} whose coordinates are defined as
Longitude/Latitude in the ETRS89 Coordinate Reference System.
}
\description{
Converts ETRS89-LAEA Easting/Northing to ETRS89 geodetic coordinates
(EPSG:4258)
}
\details{
ETRS89-LAEA (EPSG:3035) is a CRS for pan-European statistical mapping at all
scales or other purposes where true area representation is required.
}
\examples{
prj <- sgo_points(list(3962799.45, 2999718.85), epsg=3035)
p <- sgo_laea_etrs(prj)
}
\references{
IOGP Publication 373-7-2 - Geomatics Guidance Note number 7,
part 2 (October 2020). https://epsg.org/guidance-notes.html
}
\seealso{
\code{\link{sgo_points}}, \code{\link{sgo_area}}.
}
