% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgo_wgs84.R
\encoding{UTF-8}
\name{sgo_en_wgs84}
\alias{sgo_en_wgs84}
\title{Pseudo - Mercator to WGS84 Longitude/Latitude}
\usage{
sgo_en_wgs84(x, to = 4326)
}
\arguments{
\item{x}{A \code{sgo_points} object describing a set of points in the
geodetic coordinate system EPSG=3857.}

\item{to}{Numeric. Sets the \code{epsg} code of the destination Geodetic
Coordinate System. 4326 (WGS84) by default. And currently doesn't support any
other.}
}
\value{
An object of class \code{sgo_points} whose coordinates are defined as
Longitude/Latitude.
}
\description{
Converts Pseudo - Mercator coordinates to WGS84 (EPSG=4326)
}
\details{
Currently converts ONLY from EPSG 3857 to 4326 (Longitude/Latitude).
}
\examples{
p <- sgo_points(list(-11169055.58, 2810000.00), epsg=3857)
res <- sgo_en_wgs84(p)
}
\references{
IOGP Publication 373-7-2 - Geomatics Guidance Note number 7,
part 2 (October 2020). https://epsg.org/guidance-notes.html
}
\seealso{
\code{\link{sgo_points}}, \code{\link{sgo_wgs84_en}}.
}
