% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_args.R
\name{prepare.args.sgldata}
\alias{prepare.args.sgldata}
\title{Prepare sgl function arguments}
\usage{
\method{prepare.args}{sgldata}(data, parameterGrouping = NULL,
  groupWeights = NULL, parameterWeights = NULL,
  parameterNames = NULL, alpha, test_data = NULL, ...)
}
\arguments{
\item{data}{a sgldata object}

\item{parameterGrouping}{grouping of parameters, a vector of length \eqn{p}. Each element of the vector specifying the group of the parameters in the corresponding column of \eqn{\beta}.}

\item{groupWeights}{the group weights, a vector of length \code{length(unique(parameterGrouping))} (the number of groups).}

\item{parameterWeights}{a matrix of size \eqn{q \times p}, that is the same dimension as \eqn{\beta}.}

\item{parameterNames}{dim-names of parameters, if NULL \code{dimnames(parameterWeights)} will be used.}

\item{alpha}{the \eqn{\alpha} value 0 for group lasso, 1 for lasso, between 0 and 1 gives a sparse group lasso penalty.}

\item{test_data}{optional test data to be prepared (a sgldata object)}

\item{...}{not used}
}
\description{
Prepare sgl function arguments using sgldata.
}
\seealso{
Other sgldata: \code{\link{add_data.sgldata}},
  \code{\link{create.sgldata}}, \code{\link{prepare.args}},
  \code{\link{prepare_data}},
  \code{\link{rearrange.sgldata}},
  \code{\link{subsample.sgldata}}
}
\author{
Martin Vincent
}
\concept{sgldata}
