% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgdGMF-class.R
\name{simulate.sgdgmf}
\alias{simulate.sgdgmf}
\title{Simulate method for GMF models}
\usage{
\method{simulate}{sgdgmf}(object, ..., nsim = 1)
}
\arguments{
\item{object}{an object of class \code{sgdgmf}}

\item{...}{further arguments passed to or from other methods}

\item{nsim}{number of samples}
}
\value{
An 3-fold array containing the simulated data.
}
\description{
Simulate new data from a fitted generalized matrix factorization models
}
\examples{
# Load the sgdGMF package
library(sgdGMF)

# Generate data from a Poisson model
data = sim.gmf.data(n = 100, m = 20, ncomp = 5, family = poisson())

# Fit a GMF model
gmf = sgdgmf.fit(data$Y, ncomp = 3, family = poisson())

# Simulate new data from a GMF model
str(simulate(gmf))

}
