% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_url_query_string.R
\name{build_url_query_string}
\alias{build_url_query_string}
\title{Build URL Query String}
\usage{
build_url_query_string(prefix = "?", sep = "&", value_sep = ",", ...)
}
\arguments{
\item{prefix}{Prefix to returned URL. Defaults to "?".}

\item{sep}{. String separating used to separate in the URL output
each named argument in (...). Defaults to "&".}

\item{value_sep}{String separating each item in value if the
value part of a named argument is a vector. Defaults to ",".}

\item{...}{Any number of named argument pairs where the value must be
coercible to character}
}
\value{
A string containing the named arguments parsed into the URL query string format
}
\description{
Takes named arguments (...) and creates a URL query string starting
with 'prefix' with each named pair of arguments separated with 'sep'
and each item within a value that is a vector separated by 'value_sep'.

Each value part of the named arguments must be coercible to character.
For example, list(key1 = "value1", key2 = 42, key3 = c(1, 2, 4)) would
be acceptable as it can all be coerced to characters
}
\examples{
build_url_query_string()
""
build_url_query_string(field1 = "option1")
"?field1=option1"
build_url_query_string(field1 = "option1", field2 = 42, field3 = c(1, 2, 3))
"?field1=option1&field2=42&field3=1,2,3"
build_url_query_string(prefix = "/query?", sep = "|", value_sep = ":", 
                       field1 = 1, field2 = c(7, 8, 9))
"/query?field1=1|field2=7:8:9"

}
