% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb-match-test-impl.R
\name{nb_match_test}
\alias{nb_match_test}
\title{Local Neighbor Match Test}
\usage{
nb_match_test(
  x,
  nb,
  wt = st_weights(nb),
  k = 10,
  nsim = 499,
  scale = TRUE,
  .method = "euclidian",
  .p = 2
)
}
\arguments{
\item{x}{a numeric vector or a list of numeric vectors of equal length.}

\item{nb}{a neighbor list object for example as created by \code{st_contiguity()}.}

\item{wt}{a weights list as created by \code{st_weights()}.}

\item{k}{the number of neighbors to identify in attribute space. Should be the same as number of neighbors provided in \link{st_knn}.}

\item{nsim}{the number of simulations to run for calculating the simulated p-value.}

\item{scale}{default \code{TRUE}. Whether \code{x} should be scaled or not. Note that measures should be standardized.}

\item{.method}{default \code{"euclidian"}. The distance measure passed to \code{\link[stats:dist]{stats::dist()}}.}

\item{.p}{default 2. The power of Minkowski distance passed to the \code{p} argument in \code{\link[stats:dist]{stats::dist()}}.}
}
\value{
a \code{data.frame} with columns
\itemize{
\item \code{n_shared} (integer): the number of shared neighbors between geographic and attribute space
\item \code{nb_matches} (list): matched neighbor indexes. Each element is an integer vector of same length as the ith observation of \code{n_shared}
\item \code{knn_nb} (list): the neighbors in attribute space
\item \code{probability} (numeric): the geometric probability of observing the number of matches
\item \code{p_sim} (numeric): a folded simulated p-value
}
}
\description{
Implements the Local Neighbor Match Test as described in \emph{Tobler's Law in a Multivariate World} (Anselin and Li, 2020).
}
\examples{

if (requireNamespace("dplyr", quietly = TRUE)) {
library(magrittr)
guerry \%>\%
  dplyr::transmute(nb = st_knn(geometry, k = 10),
         nmt = nb_match_test(list(crime_pers, literacy, suicides),
                             nb, nsim = 999)) \%>\%
  tidyr::unnest(nmt)
 }
}
