% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacetime-nb-wt.R
\name{spt_nb}
\alias{spt_nb}
\title{Create time lagged spatial neighbors}
\usage{
spt_nb(nb, n_times, n_locs, k = 1)
}
\arguments{
\item{nb}{a neighbors list created from a spacetime object's geometry context.}

\item{n_times}{the number of time slices}

\item{n_locs}{the number of locations}
}
\value{
a \code{nb} list
}
\description{
Given a an spdep neighbor list (or any other list indicating row position)
of neighbors in a \code{spacetime} object's geometry context, create a neighbor
list across space and time in the \code{data} context.
}
\details{
Note that this should only be used for spacetime cubes.

This function is only available for internal development and should be used
with extreme caution.

The number of bins is equal to \code{n_times * n_locs} where each location has
a bin time-series with \code{n_times} observations. This is what makes it a
spacetime cube function.
}
\references{
https://pro.arcgis.com/en/pro-app/2.8/tool-reference/space-time-pattern-mining/create-space-time-cube.htm
}
\seealso{
\code{\link[=spt_wt]{spt_wt()}} for converting spacetime neighbors to spacetime weights.
}
\keyword{internal}
