% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacetime-activate.R
\name{active}
\alias{active}
\alias{activate}
\title{Activate spacetime context}
\usage{
active(x)

activate(x, what = NULL)
}
\arguments{
\item{x}{a spacetime object}

\item{what}{default NULL. Determines which context to activate. Valid argument values
are \code{"geometry"} and \code{"data"}. If left null, returns \code{x}.}
}
\description{
From a \code{\link{spacetime}} object, activate either the data or geometry contexts. The active object will then become available for manipulation.
}
\details{
A  \code{\link{spacetime}} object contains both a data frame and an sf object. The
data frame represents geographies over one or more time periods and the sf
object contains the geographic information for those locations.
}
\examples{
df_fp <- system.file("extdata", "bos-ecometric.csv", package = "sfdep")
geo_fp <- system.file("extdata", "bos-ecometric.geojson", package = "sfdep")

# read in data
df <- readr::read_csv(df_fp, col_types = "ccidD")
geo <- sf::read_sf(geo_fp)

# Create spacetime object called `bos`
bos <- spacetime(df, geo,
                 .loc_col = ".region_id",
                 .time_col = "time_period")

active(bos)
activate(bos, "geometry")
}
