% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_box.R
\name{st_sd_box}
\alias{st_sd_box}
\alias{st_sd_box.sfg}
\alias{st_sd_box.sf}
\alias{st_sd_box.sfc}
\title{Standard deviation box calculator in 2D or 3D}
\usage{
st_sd_box(.x, centre = NULL, weights = NULL, ...)

\method{st_sd_box}{sfg}(.x, centre = NULL, weights = NULL, ...)

\method{st_sd_box}{sf}(.x, centre = NULL, weights = NULL, ...)

\method{st_sd_box}{sfc}(.x, centre = NULL, weights = NULL, ...)
}
\arguments{
\item{.x}{\code{sf} points 2D or 3D}

\item{centre}{Numeric. Coordinates 2D or 3D of central point. Default NULL,
performs a calculation of mean_centre() from point localities}

\item{weights}{Numeric. Same length of number of .x.}

\item{...}{ignored}
}
\value{
Depends on input, "coords" returns a data.frame of 2 or 3 columns and
4 or 8 point coordinates. "param" returns a data.frame with centre
coordinates, standard deviation in each axis, space(area for 2D, volume for
3D) and number of dimensions in coordinates.
}
\description{
Calculate the spatial deviaction box from a points sf dataset.
#' @author Gabriel Gaona
}
\examples{
 requireNamespace("ggplot2", quietly = TRUE)
 library(sf, quietly = TRUE)
 library(ggplot2)
 bbx <- matrix(c(697047,9553483,
                 696158,9560476,
                 700964,9561425,
                 701745,9555358),
               byrow = TRUE,
               ncol = 2)
 bbx <- st_multipoint(bbx)
 bbx <- st_cast(bbx,"POLYGON")
 bbx <- st_sfc(bbx, crs = 31992)
 set.seed(1234)
 points <- st_sf(geometry = st_sample(bbx, 100))
 SD_BOX <- st_sd_box(points)
 ggplot() +
   geom_sf(data = SD_BOX, fill = NA, color = "darkolivegreen") +
   geom_sf(data = points, color = "steelblue", size = 0.5)
}
