% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest.R
\name{st_nearest_points}
\alias{st_nearest_points}
\alias{st_nearest_points.sfc}
\alias{st_nearest_points.sfg}
\alias{st_nearest_points.sf}
\title{get nearest points between pairs of geometries}
\usage{
st_nearest_points(x, y, ...)

\method{st_nearest_points}{sfc}(x, y, ..., pairwise = FALSE)

\method{st_nearest_points}{sfg}(x, y, ...)

\method{st_nearest_points}{sf}(x, y, ...)
}
\arguments{
\item{x}{object of class \code{sfg}, \code{sfc} or \code{sf}}

\item{y}{object of class \code{sfg}, \code{sfc} or \code{sf}}

\item{...}{ignored}

\item{pairwise}{logical; if \code{FALSE} (default) return nearest points between all pairs, if \code{TRUE}, return nearest points between subsequent pairs.}
}
\value{
an \link{sfc} object with all two-point \code{LINESTRING} geometries of point pairs from the first to the second geometry, of length x * y, with y cycling fastest. See examples for ideas how to convert these to \code{POINT} geometries.
}
\description{
get nearest points between pairs of geometries
}
\details{
in case \code{x} lies inside \code{y}, when using S2, the end points 
are on polygon boundaries, when using GEOS the end point are identical to \code{x}.
}
\examples{
r = sqrt(2)/10
pt1 = st_point(c(.1,.1))
pt2 = st_point(c(.9,.9))
pt3 = st_point(c(.9,.1))
b1 = st_buffer(pt1, r)
b2 = st_buffer(pt2, r)
b3 = st_buffer(pt3, r)
(ls0 = st_nearest_points(b1, b2)) # sfg
(ls = st_nearest_points(st_sfc(b1), st_sfc(b2, b3))) # sfc
plot(b1, xlim = c(-.2,1.2), ylim = c(-.2,1.2), col = NA, border = 'green')
plot(st_sfc(b2, b3), add = TRUE, col = NA, border = 'blue')
plot(ls, add = TRUE, col = 'red')

nc = st_read(system.file("gpkg/nc.gpkg", package="sf"))
plot(st_geometry(nc))
ls = st_nearest_points(nc[1,], nc)
plot(ls, col = 'red', add = TRUE)
pts = st_cast(ls, "POINT") # gives all start & end points
# starting, "from" points, corresponding to x:
plot(pts[seq(1, 200, 2)], add = TRUE, col = 'blue')
# ending, "to" points, corresponding to y:
plot(pts[seq(2, 200, 2)], add = TRUE, col = 'green')

}
\seealso{
\link{st_nearest_feature} for finding the nearest feature
}
