% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{st_join}
\alias{st_join}
\title{spatial left or inner join}
\usage{
st_join(x, y, join = st_intersects, FUN, suffix = c(".x", ".y"),
  prepared = FALSE, left = TRUE)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{y}{object of class \code{sf}}

\item{join}{geometry predicate function with the same profile as \link{st_intersects}; see details}

\item{FUN}{aggregation function, see \link[stats]{aggregate}; in case of multiple matches, if \code{FUN} is defined, attributes of \code{y} will be aggregated using \code{FUN}; else, all combinations of \code{x} and \code{y} are returned.}

\item{suffix}{length 2 character vector; see \link[base]{merge}}

\item{prepared}{logical; see \link{st_intersects}}

\item{left}{logical; if \code{TRUE} carry out left join, else inner join; 
see also \link[dplyr]{left_join}}
}
\value{
an object of class \code{sf}, joined based on geometry
}
\description{
spatial left or inner join
}
\details{
alternative values for argument \code{join} are: \link{st_disjoint}
\link{st_touches} \link{st_crosses} \link{st_within} \link{st_contains}
\link{st_overlaps} \link{st_covers} \link{st_covered_by} \link{st_equals} or
\link{st_equals_exact}, or user-defined functions of the same profile
}
\examples{
a = st_sf(a = 1:3,
 geom = st_sfc(st_point(c(1,1)), st_point(c(2,2)), st_point(c(3,3))))
b = st_sf(a = 11:14,
 geom = st_sfc(st_point(c(10,10)), st_point(c(2,2)), st_point(c(2,2)), st_point(c(3,3))))
st_join(a, b)
st_join(a, b, left = FALSE)
st_join(a, b, FUN = mean)
st_join(a, b, FUN = mean, left = FALSE)
}

