% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-values.R
\name{setter}
\alias{copy_all_attributes}
\alias{copy_attributes}
\alias{copy_class}
\alias{copy_colnames}
\alias{copy_comment}
\alias{copy_dim}
\alias{copy_dimnames}
\alias{copy_length}
\alias{copy_levels}
\alias{copy_mode}
\alias{copy_most_attributes}
\alias{copy_names}
\alias{copy_rownames}
\alias{copy_storage_mode}
\alias{mutator}
\alias{set_attributes}
\alias{set_class}
\alias{set_colnames}
\alias{set_comment}
\alias{set_dim}
\alias{set_dimnames}
\alias{set_length}
\alias{set_levels}
\alias{set_mode}
\alias{set_names}
\alias{set_rownames}
\alias{set_storage_mode}
\alias{setter}
\alias{setters}
\title{Set attributes of variables}
\usage{
set_class(x, value)

copy_class(x, from)

set_mode(x, value)

copy_mode(x, from)

set_storage_mode(x, value)

copy_storage_mode(x, from)

set_dim(x, value)

copy_dim(x, from)

set_length(x, value)

copy_length(x, from)

set_names(x, value)

copy_names(x, from)

set_colnames(x, value)

copy_colnames(x, from)

set_rownames(x, value)

copy_rownames(x, from)

set_dimnames(x, value)

copy_dimnames(x, from)

set_levels(x, value)

copy_levels(x, from)

set_comment(x, value)

copy_comment(x, from)

set_attributes(x, ..., .dots = list())

copy_attributes(x, from, attribs)

copy_all_attributes(x, from)

copy_most_attributes(x, from)
}
\arguments{
\item{x}{An R variable.}

\item{value}{A value to set the attribute to.}

\item{from}{A variable to take the attribute value from.}

\item{...}{Name-value pairs of attributes to set.}

\item{.dots}{A named list of attributes to set.}

\item{attribs}{A character vector of attributes to copy.}
}
\value{
\code{x} is returned, with updated attributes.
}
\description{
Set attributes of a variable, then return that variable.
}
\examples{
if(requireNamespace("magrittr"))
{
  `\%>\%` <- magrittr::`\%>\%`
  # Convert a vector to a matrix by setting the dimensions and their names.
  m <- 1:12 \%>\%
    set_dim(3:4) \%>\%
    set_dimnames(list(letters[1:3], LETTERS[1:4])) \%>\%
    print

  # Copy attributes from one variable to another using copy_* fns.
  month.abb \%>\%
    copy_dim(m) \%>\%
    copy_dimnames(m) \%>\%
    print

  # Same again, using copy_attributes
  month.abb \%>\%
    copy_attributes(m, c("dim", "dimnames"))

  # Same again, in this case you can copy most/all the attributes from m.
  month.abb \%>\%
    copy_most_attributes(m)
  month.abb \%>\%
    copy_all_attributes(m)

  # To quickly convert a list into a data.frame, set the class and row names.
  list(a = (1:5) ^ 2, b = pi ^ (1:5)) \%>\%
    set_class("data.frame") \%>\%
    set_rownames() \%>\%   # data.frames have a default
    print

  # Or equivalently, using attributes
  list(a = (1:5) ^ 2, b = pi ^ (1:5)) \%>\%
    set_attributes(class = "data.frame", row.names = .set_row_names(5)) \%>\%
    print
} else
{
  message('This example requires the magrittr package.  Please run install.packages("magrittr").')
}
}
\seealso{
\code{\link[base]{attributes}}, \code{\link[base]{attr}}
}

