% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_management.R
\name{sst_pm_create_project}
\alias{sst_pm_create_project}
\title{Create a new project}
\usage{
sst_pm_create_project(api_token, domain, name, groups = NULL)
}
\arguments{
\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}.}

\item{domain}{(required) Domain to get data for.}

\item{name}{(required) The name of the project. Can be different from the
domain.}

\item{groups}{(optional) A list of project groups the project should be added
to.}
}
\value{
Returns the project ID for the created project.
}
\description{
Creates a new project in Serpstat.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://serpstat.com/api/project-creation/}{here}.
}

\section{API credits consumption}{
 1 project credit.
}

\examples{
\dontrun{
api_token <- Sys.getenv('SERPSTAT_API_TOKEN')
sst_pm_create_project(
  api_token = api_token,
  domain    = 'serpstat.com',
  name      = 'Serpstat'
  )$data$project_id
}
}
