% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_analytics.R
\name{sst_sa_keyword_top}
\alias{sst_sa_keyword_top}
\title{Top for a keyword}
\usage{
sst_sa_keyword_top(api_token, keyword, se, top_size = 100)
}
\arguments{
\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}.}

\item{keyword}{(required) A keyword to search for.}

\item{se}{(required) Search engine alias (db_name) returned by
\code{\link{sst_sa_database_info}}.}

\item{top_size}{(optional) Set the number of URLs to get in response.}
}
\value{
Returns a list with the data about search engine results page for the keyword.
}
\description{
Returns a list of results (URLs) from search engine results page (SERP) including
organic results, paid results and different types of SERP features.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://serpstat.com/api/598-keyword-top-v4-serpstatkeywordproceduregetkeywordtop/}{here}.
}

\section{API rows consumption}{
 1 per URL in response.
}

\examples{
\dontrun{
api_token <- Sys.getenv('SERPSTAT_API_TOKEN')
sst_sa_keyword_top(
  api_token = api_token,
  keyword   = 'serpstat',
  se        = 'g_us',
  top_size  = 10
)
}
}
