% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PedToNum.R
\name{PedToNum}
\alias{PedToNum}
\title{Turn Character Pedigree into Numeric Pedigree}
\usage{
PedToNum(
  Pedigree = NULL,
  gID = NULL,
  DoDummies = "new",
  DumPrefix = c("F0", "M0")
)
}
\arguments{
\item{Pedigree}{dataframe with id - dam - sire. It is assumed
\code{\link{PedPolish}} has been called beforehand so that column names are
correct and all columns are as.character.}

\item{gID}{vector with IDs of SNP-genotyped individuals.}

\item{DoDummies}{'new', 'old', or 'no' (ignore all non-genotyped
individuals).}

\item{DumPrefix}{Prefix to identify dummies when \code{DoDummies = 'old'}}
}
\value{
a list with
  \item{PedPar}{An nInd x 2 matrix with the numeric IDs of parents of
    genotyped individuals}
  \item{DumPar}{A matrix with parents of dummies, see
    \code{\link{FoldSibGPs}}}
  \item{Renamed}{a length-2 list (dams, sires) with each element a dataframe
    with columns: 'name' (original character ID), 'num' (number ID, negative)
    for each dummified individual}
  \item{Nd}{a length 2 vector, no. dummies found/created for dams and sires}
}
\description{
Genotyped individuals get rownumber in genotype matrix,
  non-genotyped individuals either all get an arbitrary negative number
  (\code{DoDummies = 'new'}) or only individuals with a dummy ID get the
  corresponding negative number (\code{DoDummies = 'old'}). Note that the
  number series will overlap for dummy males and dummy females.
}
\details{
If \code{DoDummies='new'}, \code{\link{GetDummifiable}} is used
  with \code{minSibSize = "1sib"}, and any existing dummy coding is ignored
  (F0001, F0002 may become -3, -6). If \code{DoDummies='old'}, the existing
  dummy coding is respected (F0001, F0002 will become -1, -2), but other
  non-genotyped individuals are ignored.
}
\keyword{internal}
