% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequoia_F90wrappers.R
\name{WrapDup}
\alias{WrapDup}
\title{Check data for duplicates.}
\usage{
WrapDup(FortList, gID, LhIN, quiet = FALSE)
}
\arguments{
\item{LhIN}{life history data}

\item{quiet}{suppress messages}

\item{Specs}{The 1-row dataframe with parameter values}

\item{GenoM}{matrix with genotype data, size nInd x nSnp}
}
\value{
A list with one or more of the following elements:
\item{DupGenoID}{Dataframe, rownumbers of duplicated IDs in genotype data.
  Please do remove or relabel these to avoid downstream confusion.}
\item{DupGenotype}{Dataframe, duplicated genotypes (with or without
  identical IDs). The specified number of maximum mismatches is allowed,
  and this dataframe may include pairs of closely related individuals.
  Mismatch = number of SNPs at which genotypes differ, LLR = likelihood
  ratio between 'self' and most likely non-self.}
\item{DupLifeHistID}{Dataframe, rownumbers of duplicated IDs in life
  history data}
\item{NoLH}{Vector, IDs (in genotype data) for which no life history data is
provided}
}
\description{
Check the genotype and life history data for duplicate IDs (not
  permitted) and duplicated genotypes (not advised), and count how many
  individuals in the genotype data are not included in the life history data
  (permitted). The order of IDs in the genotype and life history data is not
  required to be identical.
}
\keyword{internal}
