#pragma once

#include <vector>

#include "custom_vector_hasher.h"

namespace hashing::config {

using single_hash_t = uint64_t;

using multidim_hash_t = std::vector<single_hash_t>;

using multidim_hasher_t = std::hash<multidim_hash_t>;

namespace internal {

inline const static std::vector<int> pValues{
    31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997, 1009, 1013, 1019, 1021, 1031, 1033, 1039, 1049, 1051, 1061, 1063, 1069, 1087, 1091, 1093, 1097, 1103, 1109, 1117, 1123, 1129, 1151, 1153, 1163, 1171, 1181, 1187, 1193, 1201, 1213, 1217, 1223, 1229, 1231, 1237, 1249, 1259, 1277, 1279, 1283, 1289, 1291, 1297, 1301, 1303, 1307, 1319, 1321, 1327, 1361, 1367, 1373, 1381, 1399, 1409, 1423, 1427, 1429, 1433, 1439, 1447, 1451, 1453, 1459, 1471, 1481, 1483, 1487, 1489, 1493, 1499, 1511, 1523, 1531, 1543, 1549, 1553, 1559, 1567, 1571, 1579, 1583, 1597, 1601, 1607, 1609, 1613, 1619, 1621, 1627, 1637, 1657, 1663, 1667, 1669, 1693, 1697, 1699, 1709, 1721, 1723, 1733, 1741, 1747, 1753, 1759, 1777, 1783, 1787, 1789, 1801, 1811, 1823, 1831, 1847, 1861, 1867, 1871, 1873, 1877, 1879, 1889, 1901, 1907, 1913, 1931, 1933, 1949, 1951, 1973, 1979, 1987, 1993, 1997, 1999, 2003, 2011, 2017, 2027, 2029, 2039, 2053, 2063, 2069, 2081, 2083, 2087, 2089, 2099, 2111, 2113, 2129, 2131, 2137, 2141, 2143, 2153, 2161, 2179, 2203, 2207, 2213, 2221, 2237, 2239, 2243, 2251, 2267, 2269, 2273, 2281, 2287, 2293, 2297, 2309, 2311, 2333, 2339, 2341, 2347, 2351, 2357, 2371, 2377, 2381, 2383, 2389, 2393, 2399, 2411, 2417, 2423, 2437, 2441, 2447, 2459, 2467, 2473, 2477, 2503, 2521, 2531, 2539, 2543, 2549, 2551, 2557, 2579, 2591, 2593, 2609, 2617, 2621, 2633, 2647, 2657, 2659, 2663, 2671, 2677, 2683, 2687, 2689, 2693, 2699, 2707, 2711, 2713, 2719, 2729, 2731, 2741, 2749, 2753, 2767, 2777, 2789, 2791, 2797, 2801, 2803, 2819, 2833, 2837, 2843, 2851, 2857, 2861, 2879, 2887, 2897, 2903, 2909, 2917, 2927, 2939, 2953, 2957, 2963, 2969, 2971, 2999, 3001, 3011, 3019, 3023, 3037, 3041, 3049, 3061, 3067, 3079, 3083, 3089, 3109, 3119, 3121, 3137, 3163, 3167, 3169, 3181, 3187, 3191, 3203, 3209, 3217, 3221, 3229, 3251, 3253, 3257, 3259, 3271, 3299, 3301, 3307, 3313, 3319, 3323, 3329, 3331, 3343, 3347, 3359, 3361, 3371, 3373, 3389, 3391, 3407, 3413, 3433, 3449, 3457, 3461, 3463, 3467, 3469, 3491, 3499, 3511, 3517, 3527, 3529, 3533, 3539, 3541, 3547, 3557, 3559, 3571, 3581, 3583, 3593, 3607, 3613, 3617, 3623, 3631, 3637, 3643, 3659, 3671, 3673, 3677, 3691, 3697, 3701, 3709, 3719, 3727, 3733, 3739, 3761, 3767, 3769, 3779, 3793, 3797, 3803, 3821, 3823, 3833, 3847, 3851, 3853, 3863, 3877, 3881, 3889, 3907, 3911, 3917, 3919, 3923, 3929, 3931, 3943, 3947, 3967, 3989, 4001, 4003, 4007, 4013, 4019, 4021, 4027, 4049, 4051, 4057, 4073, 4079, 4091, 4093, 4099, 4111, 4127, 4129, 4133, 4139, 4153, 4157, 4159, 4177, 4201, 4211, 4217, 4219, 4229, 4231, 4241, 4243, 4253, 4259, 4261, 4271, 4273, 4283, 4289, 4297, 4327, 4337, 4339, 4349, 4357, 4363, 4373, 4391, 4397, 4409};

inline const static std::vector<int> mValues{
    1500000001, 1500000041, 1500000043, 1500000059, 1500000077, 1500000079, 1500000101, 1500000107, 1500000113, 1500000167, 1500000233, 1500000283, 1500000301, 1500000373, 1500000377, 1500000409, 1500000419, 1500000427, 1500000449, 1500000473, 1500000511, 1500000527, 1500000529, 1500000563, 1500000577, 1500000587, 1500000613, 1500000617, 1500000701, 1500000707, 1500000713, 1500000721, 1500000739, 1500000743, 1500000767, 1500000773, 1500000779, 1500000787, 1500000823, 1500000829, 1500000839, 1500000851, 1500000857, 1500000871, 1500000877, 1500000893, 1500000917, 1500000973, 1500001003, 1500001033, 1500001043, 1500001049, 1500001117, 1500001213, 1500001231, 1500001241, 1500001271, 1500001291, 1500001319, 1500001333, 1500001337, 1500001343, 1500001367, 1500001369, 1500001387, 1500001397, 1500001411, 1500001421, 1500001439, 1500001453, 1500001457, 1500001507, 1500001543, 1500001549, 1500001553, 1500001577, 1500001661, 1500001673, 1500001709, 1500001733, 1500001747, 1500001751, 1500001753, 1500001777, 1500001799, 1500001801, 1500001847, 1500001859, 1500001891, 1500001907, 1500001927, 1500001939, 1500001967, 1500002057, 1500002069, 1500002071, 1500002087, 1500002099, 1500002113, 1500002117, 1500002129, 1500002143, 1500002149, 1500002197, 1500002219, 1500002233, 1500002323, 1500002381, 1500002401, 1500002419, 1500002423, 1500002503, 1500002521, 1500002527, 1500002579, 1500002591, 1500002593, 1500002639, 1500002653, 1500002657, 1500002663, 1500002687, 1500002689, 1500002741, 1500002827, 1500002849, 1500002869, 1500002909, 1500002923, 1500002971, 1500003049, 1500003067, 1500003077, 1500003101, 1500003133, 1500003139, 1500003161, 1500003179, 1500003181, 1500003209, 1500003233, 1500003251, 1500003283, 1500003287, 1500003289, 1500003299, 1500003311, 1500003319, 1500003371, 1500003451, 1500003493, 1500003497, 1500003499, 1500003539, 1500003553, 1500003587, 1500003607, 1500003611, 1500003613, 1500003641, 1500003667, 1500003671, 1500003683, 1500003691, 1500003709, 1500003733, 1500003767, 1500003779, 1500003803, 1500003871, 1500003877, 1500003907, 1500003937, 1500003943, 1500003961, 1500003977, 1500003991, 1500004019, 1500004031, 1500004049, 1500004057, 1500004067, 1500004081, 1500004111, 1500004127, 1500004159, 1500004169, 1500004189, 1500004193, 1500004199, 1500004237, 1500004249, 1500004277, 1500004279, 1500004283, 1500004339, 1500004349, 1500004351, 1500004447, 1500004459, 1500004477, 1500004543, 1500004567, 1500004573, 1500004589, 1500004621, 1500004633, 1500004661, 1500004663, 1500004703, 1500004711, 1500004769, 1500004771, 1500004789, 1500004829, 1500004867, 1500004879, 1500004921, 1500004927, 1500004973, 1500005011, 1500005041, 1500005093, 1500005107, 1500005113, 1500005173, 1500005209, 1500005231, 1500005233, 1500005261, 1500005357, 1500005389, 1500005393, 1500005399, 1500005453, 1500005471, 1500005497, 1500005519, 1500005527, 1500005537, 1500005539, 1500005543, 1500005579, 1500005603, 1500005671, 1500005681, 1500005687, 1500005713, 1500005719, 1500005723, 1500005737, 1500005747, 1500005777, 1500005779, 1500005783, 1500005807, 1500005813, 1500005833, 1500005879, 1500005887, 1500005917, 1500005933, 1500005989, 1500006031, 1500006047, 1500006059, 1500006097, 1500006107, 1500006113, 1500006119, 1500006127, 1500006133, 1500006253, 1500006257, 1500006289, 1500006311, 1500006317, 1500006323, 1500006349, 1500006463, 1500006481, 1500006499, 1500006503, 1500006511, 1500006523, 1500006533, 1500006569, 1500006589, 1500006631, 1500006667, 1500006719, 1500006727, 1500006749, 1500006769, 1500006773, 1500006839, 1500006857, 1500006869, 1500006881, 1500006887, 1500006913, 1500006919, 1500006929, 1500006931, 1500006941, 1500006961, 1500006967, 1500006983, 1500006997, 1500007009, 1500007027, 1500007037, 1500007043, 1500007051, 1500007057, 1500007073, 1500007111, 1500007129, 1500007133, 1500007151, 1500007153, 1500007163, 1500007211, 1500007217, 1500007237, 1500007253, 1500007277, 1500007283, 1500007297, 1500007357, 1500007373, 1500007403, 1500007429, 1500007433, 1500007441, 1500007451, 1500007463, 1500007477, 1500007501, 1500007517, 1500007549, 1500007567, 1500007603, 1500007609, 1500007697, 1500007711, 1500007727, 1500007759, 1500007781, 1500007811, 1500007843, 1500007879, 1500007891, 1500007973, 1500007981, 1500008021, 1500008053, 1500008057, 1500008077, 1500008101, 1500008119, 1500008123, 1500008131, 1500008197, 1500008201, 1500008207, 1500008249, 1500008297, 1500008309, 1500008317, 1500008381, 1500008387, 1500008399, 1500008401, 1500008407, 1500008423, 1500008449, 1500008473, 1500008567, 1500008579, 1500008591, 1500008659, 1500008681, 1500008707, 1500008729, 1500008737, 1500008747, 1500008761, 1500008771, 1500008773, 1500008801, 1500008837, 1500008843, 1500008857, 1500008899, 1500008927, 1500008933, 1500008953, 1500008959, 1500008987, 1500009019, 1500009053, 1500009073, 1500009113, 1500009151, 1500009157, 1500009167, 1500009221, 1500009223, 1500009227, 1500009281, 1500009289, 1500009299, 1500009361, 1500009391, 1500009409, 1500009437, 1500009457, 1500009461, 1500009481, 1500009487, 1500009491, 1500009499, 1500009503, 1500009529, 1500009547, 1500009571, 1500009613, 1500009629, 1500009631, 1500009677, 1500009683, 1500009727, 1500009733, 1500009751, 1500009793, 1500009817, 1500009839, 1500009857, 1500009899, 1500009911, 1500009919, 1500009941, 1500009983, 1500010013, 1500010033, 1500010073, 1500010097, 1500010103, 1500010121, 1500010139, 1500010177, 1500010189, 1500010201, 1500010219, 1500010223, 1500010241, 1500010261, 1500010301, 1500010319, 1500010349, 1500010357, 1500010373, 1500010403, 1500010411, 1500010417, 1500010433, 1500010483, 1500010493, 1500010507, 1500010541, 1500010549, 1500010583, 1500010591, 1500010639, 1500010649, 1500010661, 1500010663, 1500010693, 1500010741, 1500010763, 1500010783, 1500010817, 1500010829, 1500010873, 1500010891, 1500010901, 1500010907, 1500010931, 1500010937, 1500010949, 1500010957, 1500011003, 1500011017, 1500011039, 1500011041, 1500011047, 1500011057, 1500011077, 1500011089};

auto prepareHashPrimes(int hashDim) {
  std::vector<std::pair<int, int>> res;
  for (int i = 0; i < hashDim; ++i) {
    res.emplace_back(pValues[i], mValues[i]);
  }
  return res;
}
}  // namespace internal

inline const static auto hashPrimes = internal::prepareHashPrimes(500);

}  // namespace hashing::config
