% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{weights_beta}
\alias{weights_beta}
\title{Compute Beta weighting curves}
\usage{
weights_beta(n, a = 1:4, b = 1:4, do.normalize = TRUE)
}
\arguments{
\item{n}{a single \code{numeric} to indicate the lag length (cf., \emph{n}).}

\item{a}{a \code{numeric} as the first parameter (cf., \emph{a}).}

\item{b}{a \code{numeric} as the second parameter (cf., \emph{b}).}

\item{do.normalize}{a \code{logical}, if \code{TRUE} weights are normalized to unity.}
}
\value{
A \code{data.frame} of beta weighting curves per combination of \code{a} and \code{b}. If \code{n = 1},
all weights are set to 1.
}
\description{
Computes Beta weighting curves as in Ghysels, Sinko and Valkanov (2007). Handy to self-select specific
time aggregation weighting schemes for input in \code{\link{ctr_agg}} using the \code{weights} argument.
}
\details{
The Beta weighting abides by following formula:
\eqn{f(i/n; a, b) / \sum_{i}(i/n; a, b)}{f(i/n; a, b) / \sum(i/n; a, b)}, where \eqn{i} is the lag index ordered
from 1 to \eqn{n}, \eqn{a} and \eqn{b} are two decay parameters, and
\eqn{f(x; a, b) = (x^{a - 1}(1 - x)^{b - 1}\Gamma(a + b)) / (\Gamma(a)\Gamma(b))}{f(x; a, b)
 = (x^(a - 1) * (1 - x)^(b - 1) * T(a + b)) / (T(a) * T(b))}, where \eqn{\Gamma(.)}{T(.)} is
the \code{\link{gamma}} function.
}
\references{
Ghysels, Sinko and Valkanov (2007). \strong{MIDAS regressions: Further results and new directions}.
\emph{Econometric Reviews 26, 53-90}, \url{https://doi.org/10.1080/07474930600972467}.
}
\seealso{
\code{\link{ctr_agg}}
}
