% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures_measures_xyz.R
\name{measures_select}
\alias{measures_select}
\title{Select sentiment measures}
\usage{
measures_select(sentomeasures, toSelect)
}
\arguments{
\item{sentomeasures}{a \code{sentomeasures} object created using \code{\link{sento_measures}}.}

\item{toSelect}{a \code{character} vector of the lexicon, feature and time weighting scheme names, to indicate which
measures need to be selected, or as a \code{list} of \code{character} vectors, possibly with separately specified
combinations (only consisting of one lexicon, one feature, and one time weighting scheme at maximum).}
}
\value{
A modified \code{sentomeasures} object, with only the sentiment measures required, including updated information
and statistics, but the original sentiment scores \code{data.table} untouched.
}
\description{
Selects all sentiment measures which include either all of the given selection components combined,
or those who's name consist of at least one of the selection components.
}
\examples{
data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")

# construct a sentomeasures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- sento_lexicons(list_lexicons[c("LM_en", "HENRY_en")], list_valence_shifters[["en"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "year", lag = 3)
sentomeasures <- sento_measures(corpusSample, l, ctr)

# different selections
sel1 <- measures_select(sentomeasures, c("equal_weight"))
sel2 <- measures_select(sentomeasures, c("equal_weight", "linear"))
sel3 <- measures_select(sentomeasures, c("linear", "LM_en"))
sel4 <- measures_select(sentomeasures, list(c("linear", "wsj"), c("linear", "economy")))

}
\seealso{
\code{\link{measures_delete}}
}
\author{
Samuel Borms
}
