% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentiment.R
\name{sentiment_match}
\alias{sentiment_match}
\title{Sentiment Matching}
\usage{
sentiment_match(
  x = NULL,
  phrases = NULL,
  model = names(default_models),
  batch_size = 100,
  ...
)
}
\arguments{
\item{x}{A plain text vector or column name if data is supplied.
If you know what you're doing, you can also pass in a 512-D numeric embedding}

\item{phrases}{A named list of examples phrases with each element of the list
being words/terms that are indications of the name of that element (
such as positive words/terms under the name "positive" and negative
words/terms under the name "negative", all within the same list)}

\item{model}{An embedding name from tensorflow-hub, some of which are
"en" (english large or not) and "multi" (multi-lingual large or not).}

\item{batch_size}{Size of batches to use. Larger numbers will be faster than
smaller numbers, but do not exhaust your system memory!}

\item{...}{Additional arguments passed to \code{\link[reticulate:conda-tools]{conda_install()}}
or \code{\link[reticulate:virtualenv-tools]{virtualenv_install()}}.}
}
\value{
data.table containing text, sentiment, phrase, class, and similarity.
}
\description{
Provides score and explanation, returns a single vector, and runs relatively
fast.
}
\examples{
\dontrun{
envname   <- "r-sentiment-ai"

# make sure to install sentiment ai (install_sentiment.ai)
# install_sentiment.ai(envname = envname,
#                      method  = "conda")

# running the model
mod_match <- sentiment_match(x       = airline_tweets$text,
                             model   = "en.large",
                             envname = envname)

# checking performance
pos_neg <- factor(airline_tweets$airline_sentiment,
                  levels = c("negative", "neutral", "positive"))
pos_neg <- (as.numeric(pos_neg) - 1) / 2
cosine(mod_match$sentiment, pos_neg)

# you could also calculate accuracy/kappa
}

}
