% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensi_plot.sensiClade.R
\name{sensi_plot.sensiClade}
\alias{sensi_plot.sensiClade}
\title{Graphical diagnostics for class 'sensiClade'}
\usage{
\method{sensi_plot}{sensiClade}(x, clade = NULL, ...)
}
\arguments{
\item{x}{output from \code{clade_phylm} or \code{clade_phyglm}}

\item{clade}{The name of the clade to be evaluated (see details)}

\item{...}{further arguments to methods.}
}
\description{
Plot results from \code{clade_phylm} and \code{clade_phyglm}
}
\details{
For 'x' from clade_phylm or clade_phyglm:

\strong{Graph 1:} The original scatterplot \eqn{y = a + bx} (with the 
full dataset) and a comparison between the regression lines of the full dataset
and the rerun without the selected clade (set by \code{clade}). For further
details about this method, see \code{\link[sensiPhy]{clade_phylm}}.

Species from the selected clade are represented in red (removed species), black
solid line represents the regression with the full model and red dashed line represents
the regression of the model without the species from the selected clade.
To check the available clades to plot, see \code{x$sensi.estimates$clade} 
in the object returned from \code{clade_phylm} or \code{clade_phyglm}. 

\strong{Graph 2:} Distribution of the simulated slopes (Null distribution
for a given clade sample size).
The red dashed line represents the estimated slope for the reduced model 
(without the focal clade) and the black line represents the slope for the 
full model.
}
\seealso{
\code{\link[sensiPhy]{clade_phylm}}
}
\author{
Gustavo Paterno
}
