% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2_thumbnails.R
\name{stack2rgb}
\alias{stack2rgb}
\title{Produce an RGB image from a multiband raster file.}
\usage{
stack2rgb(
  in_rast,
  out_file = NULL,
  bands = 1:3,
  minval = 0,
  maxval = 10000,
  format = "JPEG",
  compress = "90",
  bigtiff = FALSE,
  proc_mode = "raster",
  tmpdir = NA
)
}
\arguments{
\item{in_rast}{Input raster (as \verb{Raster*} or \code{stars} object).}

\item{out_file}{(optional) Path of the output RGB JPEG image; if NULL
(default), a RasterBrick will be returned.}

\item{bands}{(optional) 3-length integer argument, with the position of
the three bands to be used respectively for red, green and blue.}

\item{minval}{(optional) the value corresponding to black (default: 0).
Also a 3-length vector is accepted
(min values for red, green and blue respectively).}

\item{maxval}{(optional) the value corresponding to white (default: 10000).
Also a 3-length vector is accepted
(max values for red, green and blue respectively).}

\item{format}{(optional) Format of the output file (in a
format recognised by GDAL). Default is JPEG.}

\item{compress}{(optional) In the case a GTiff format is
present, the compression indicated with this parameter is used.
In the case a JPEG format is present, the compression indicates the quality
(integer, 0-100).
In the case a GTiff format is present and an integer 0-100 number is provided,
this is interpreted as the quality level of a JPEG compression.}

\item{bigtiff}{(optional) Logical: if TRUE, the creation of a BigTIFF is
forced (default is FALSE).
This option is used only in the case a GTiff format was chosen.}

\item{proc_mode}{(optional) Character: if \code{"gdal_calc"},
\code{gdal_calc} routines are used to compute indices;
if \code{"raster"} (default) or \code{"stars"}, R functions are instead used
(using respectively \code{raster} or \code{stars} routines).
\strong{Note}: default value (\code{"raster"}) is the only fully supported mode.
\code{"gdal_calc"} can be used only if a runtime GDAL environment can be properly
configured (no assistance is provided in case of GDAL-related problems).
\code{"raster"} mode is experimental.
See \code{s2_calcindices()} for further details.}

\item{tmpdir}{(optional) Path where intermediate files will be created.
Default is a temporary directory.
If \code{tmpdir} is a non-empty folder, a random subdirectory will be used.}
}
\value{
The path of the output image; alternatively, the output image
as RasterBrick (if \code{out_rast = NULL}).
}
\description{
Internal function to create JPEG images from a multiband raster
file. This function is used by \link{s2_thumbnails}, and it will be exported
when it would be more generalised.
}
\note{
License: GPL 3.0
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473. DOI:
\href{https://doi.org/10.1016/j.cageo.2020.104473}{10.1016/j.cageo.2020.104473},
URL: \url{http://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
