% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_by.R
\name{sort_by}
\alias{sort_by}
\title{Sort a Parameter Estimates
Table}
\usage{
sort_by(
  object,
  by = c("op", "lhs", "rhs"),
  op_priority = c("=~", "~", "~~", ":=", "~1", "|", "~*~"),
  number_rows = TRUE
)
}
\arguments{
\item{object}{The output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}},
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}, or
a \code{lavaan.data.frame} object.
May also work on an \code{est_table}-class
object returned by functions
like \code{\link[=group_by_dvs]{group_by_dvs()}} but there
is no guarantee.}

\item{by}{A character vector of the
columns for filtering. Default
is \code{c("op", "lhs", "rhs")}.}

\item{op_priority}{How rows are
sorted by \code{op}. Default is \code{c("=~", "~", "~~", ":=", "~1", "|", "~*~")}.
Can set only a few of the operators,
e.g., \code{c("~", "~~")}. Other operators
will be placed to the end with orders
not changed.}

\item{number_rows}{Whether the row
names will be set to row numbers
after sorting \emph{if} the row names
of \code{object} is equal to row numbers.
Default is \code{TRUE}.}
}
\value{
The sorted version of the
input object.
}
\description{
Sort a parameter
estimates table or a similar table
in\code{lavaan} by common fields such as
\code{op} (operator) and \code{lhs} (left-
hand side).
}
\details{
This functions accepts the
output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} and
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}} and
filter the rows by commonly used
field.
}
\examples{

library(lavaan)
set.seed(5478374)
n <- 50
x <- runif(n) - .5
m <- .40 * x + rnorm(n, 0, sqrt(1 - .40))
y <- .30 * m + rnorm(n, 0, sqrt(1 - .30))
dat <- data.frame(x = x, y = y, m = m)
model1 <-
'
m ~ a*x
y ~ b*m
ab := a*b
'
fit1 <- sem(model1, data = dat, fixed.x = FALSE)
model2 <-
'
m ~ a*x
y ~ b*m + x
ab := a*b
'
fit2 <- sem(model2, data = dat, fixed.x = FALSE)
parameterEstimates(fit1)
parameterEstimates(fit2)
out <- group_by_models(list(no_direct = fit1,
                            direct = fit2),
                        col_names = c("est", "pvalue"))
out
sort_by(out)
sort_by(out, op_priority = c("~", ":="))
sort_by(out, by = c("op", "rhs"))


}
\author{
Shu Fai Cheung
\url{https://orcid.org/0000-0002-9871-9448}
}
