% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pa_dat}
\alias{pa_dat}
\title{Sample Data: A Path Model}
\format{
A data frame with 100 rows
and 5 variables:
\describe{
\item{m1}{Mediator. Numeric.}
\item{dv}{Outcome variable. Numeric.}
\item{iv1}{Predictor. Numeric.}
\item{iv2}{Predictor. Numeric.}
}
}
\usage{
pa_dat
}
\description{
A four-variable dataset with 100 cases.
}
\examples{
library(lavaan)
data(pa_dat)
mod <-
"
m1 ~ a1 * iv1 + a2 * iv2
dv ~ b * m1
a1b := a1 * b
a2b := a2 * b
"
fit <- sem(mod, pa_dat)
summary(fit)
}
\keyword{datasets}
