% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sessions.R, R/sessionsDoc.R
\name{deleteSession}
\alias{deleteSession}
\title{Delete the session.}
\usage{
deleteSession(remDr, ...)
}
\arguments{
\item{remDr}{An object of class "rDriver". A remote driver object see \code{\link{remoteDr}}.}

\item{...}{Additonal function arguments - Currently passes the \code{\link{retry}} argument.}
}
\value{
Returns an object of class "rDriver". The sessionId associated with this driver has been removed however
   and the associated browser should be closed by the server.
}
\description{
\code{deleteSession} Delete the session.
}
\examples{
\dontrun{
  # start a driver without opening a browser
  remDr <- remoteDr(newSession = FALSE)

  # open a broswer
  remDr \%>\% newSession

  # set timeout on waiting for elements
  remDr \%>\% setTimeout(type = "implicit", 5000)

  # close Session
  remDr \%>\% deleteSession

}

}
\seealso{
Other sessions functions: \code{\link{newSession}},
  \code{\link{setTimeout}}
}

