% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sessions.R, R/sessionsDoc.R
\name{setTimeout}
\alias{setTimeout}
\title{Configure the amount of time that a particular type of operation can execute}
\usage{
setTimeout(remDr, type = "page load", milliseconds = 10000, ...)
}
\arguments{
\item{remDr}{An object of class "rDriver". A remote driver object see \code{\link{remoteDr}}.}

\item{type}{The type of operation to set the timeout for. Valid values are: "script" for script timeouts, "implicit" for modifying the implicit wait timeout and "page load" for setting a page load timeout.}

\item{milliseconds}{The amount of time, in milliseconds, that time-limited commands are permitted to run.}

\item{...}{Additonal function arguments - Currently passes the \code{\link{retry}} argument.}
}
\value{
invisible(remDr): An object of class "rDriver" is invisibly returned.
   A remote driver object see \code{\link{remoteDr}}. This allows for chaining from this function to
   other functions that take such an object as an argument. See examples for further details.
}
\description{
\code{setTimeout} Configure the amount of time that a particular type of operation can execute
   for before they are aborted and a |Timeout| error is returned to the client.
}
\examples{
\dontrun{
  # start a driver without opening a browser
  remDr <- remoteDr(newSession = FALSE)

  # open a broswer
  remDr \%>\% newSession

  # set timeout on waiting for elements
  remDr \%>\% setTimeout(type = "implicit", 5000)

  # close Session
  remDr \%>\% deleteSession

}

}
\seealso{
Other sessions functions: \code{\link{deleteSession}},
  \code{\link{newSession}}
}

