% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selacSim.R
\name{SelacSimulatorEvolvingRates}
\alias{SelacSimulatorEvolvingRates}
\title{Simulate DNA under the SELAC model and evolving rates}
\usage{
SelacSimulatorEvolvingRates(phy, pars, aa.optim_array,
  root.codon.frequencies, numcode = 1, aa.properties = NULL, nuc.model,
  k.levels = 0, diploid = TRUE, pars.to.evolve = "phi",
  evolve.type = "BM", evolve.pars = c(1, 0), Ne.vals.evolved = NULL)
}
\arguments{
\item{phy}{The phylogenetic tree with branch lengths.}

\item{pars}{A vector of parameters used for the simulation. They are ordered as follows: C.q.phi, alpha, beta, and Ne.}

\item{aa.optim_array}{A vector of optimal amino acids for each site to be simulated.}

\item{root.codon.frequencies}{A vector of codon frequencies for each possible optimal amino acid. Thus, the vector is of length 64x64.}

\item{numcode}{The The ncbi genetic code number for translation. By default the standard (numcode=1) genetic code is used.}

\item{aa.properties}{User-supplied amino acid distance properties. By default we assume Grantham (1974) properties.}

\item{nuc.model}{Indicates what type nucleotide model to use. There are three options: "JC", "GTR", or "UNREST".}

\item{k.levels}{Provides how many levels in the polynomial. By default we assume a single level (i.e., linear).}

\item{diploid}{A logical indicating whether or not the organism is diploid or not.}

\item{pars.to.evolve}{Indicates which parameters to assume evolve along the tree. Only two options: "phi" or "Ne".}

\item{evolve.type}{The process by which the focal parameter evovles. There are two options: Brownian motion ("BM") or Ornstein-Uhlenbeck ("OU").}

\item{evolve.pars}{The process parameters used to simulate focal parameter evolution. Under "BM", the order is root.state, rate; under "OU", the order is alpha, sigma.sq, and the mean.}

\item{Ne.vals.evolved}{Under selac we assume a global Ne for all genes. Thus, when the focal parameter to evolve is "Ne", then a user specified vector of simulated Ne values are provided here.}
}
\description{
Simulates nucleotide data based on parameters under the SELAC model but assumes either Phi or Ne evolves along the tree.
}
\details{
Simulates a nucleotide matrix using parameters under the SELAC model, but allows either Phi or Ne to evolve along the tree. Note that the output can be written to a fasta file using the write.dna() function in the \code{ape} package.
}
