% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statements_get_statements_data.R
\name{statements_get_statements_data}
\alias{statements_get_statements_data}
\title{Getting data about statements}
\usage{
statements_get_statements_data(statements_links,
  home_page = 'http://www.sejm.gov.pl/')
}
\arguments{
\item{statements_links}{list of elements of XMLNodeSet class with statements' ids, links 
and their's authors}

\item{home_page}{main page of polish diet: http://www.sejm.gov.pl/}
}
\value{
data frame with three columns: names, statements_links, ids
}
\description{
Function \code{statements_get_statements_data} gets data about statements.
}
\details{
Function \code{statements_get_statements_data} gets data about statements like
author, page with content of statement and it's id.
}
\note{
All information is stored in PostgreSQL database.
}
\examples{
\dontrun{
page <- safe_html(paste0('http://www.sejm.gov.pl/Sejm7.nsf/',
               'wypowiedz.xsp?posiedzenie=15&dzien=1&wyp=0'))
page <- html_nodes(page, '.stenogram')
statements_links <- html_nodes(page, 'h2 a')
statements_get_statements_data(statements_links,
  home_page = 'http://www.sejm.gov.pl/Sejm7.nsf/')}

}
\author{
Piotr Smuda, Tomasz Mikolajczyk
}

