% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi.R
\name{multi_lrt}
\alias{multi_lrt}
\title{Parallelized likelihood ratio test for segregation distortion.}
\usage{
multi_lrt(
  g,
  p1,
  p2,
  drbound = 1/6,
  pp = TRUE,
  dr = TRUE,
  alpha = 0,
  xi1 = 1/3,
  xi2 = 1/3,
  nullprop = FALSE
)
}
\arguments{
\item{g}{One of two inputs
\itemize{
\item{A matrix of genotype counts. The rows index the loci and the columns index the genotypes.}
\item{An array of genotype log-likelihoods. The rows index the loci, the columns index the individuals, and the slices index the genotypes. Log-likelihoods are base e (natural log).}
}}

\item{p1}{One of three inputs
\itemize{
\item{A vector of parent 1's genotypes.}
\item{A matrix of parent 1's genotype log-likelihoods. The rows index the loci and the columns index the genotypes. Logs are in base e (natural log).}
\item{\code{NULL} (only supported when using genotype likelihoods for the offspring)}
}}

\item{p2}{One of three inputs
\itemize{
\item{A vector of parent 1's genotypes.}
\item{A matrix of parent 1's genotype log-likelihoods. The rows index the loci and the columns index the genotypes. Logs are in base e (natural log).}
\item{\code{NULL} (only supported when using genotype likelihoods for the offspring)}
}}

\item{drbound}{The upper bound on the double reduction rate.}

\item{pp}{Is (partial) preferential pairing possible (\code{TRUE}) or
not (\code{FALSE})?}

\item{dr}{Is double reduction possible (\code{TRUE}) or
not (\code{FALSE})?}

\item{alpha}{If \code{dr = FALSE}, this is the known rate of double
reduction.}

\item{xi1}{If \code{pp = FALSE}, this is the known preferential pairing
parameter of parent 1.}

\item{xi2}{If \code{pp = FALSE}, this is the known preferential pairing
parameter of parent 2.}

\item{nullprop}{Should we return the null proportions (\code{TRUE}) or not (\code{FALSE})?}
}
\value{
A data frame with the following elements:
\describe{
\item{\code{statistic}}{The likelihood ratio test statistic}
\item{\code{p_value}}{The p-value of the likelihood ratio test.}
\item{\code{df}}{The degrees of freedom of the test.}
\item{\code{alpha}}{The MLE of the double reduction rate. Do not use for real work.}
\item{\code{xi1}}{The MLE of the first parent's partial preferential pairing parameter. Do not use for real work.}
\item{\code{xi2}}{The MLE of the second parent's partial preferential pairing parameter. Do not use for real work.}
\item{\code{p1}}{(Estimate of) the first parent's genotype.}
\item{\code{p2}}{(Estimate of) the second parent's genotype.}
\item{\code{snp}}{The name of the SNP.}
}
}
\description{
Uses the \code{future} package to implement parallelization support for
the likelihood ratio tests for segregation distortion. Right now, this is
only supported for tetraploids (allo, auto, or segmental). This function
is only somewhat tested (the single-locus LRT functions in the "See Also"
section are very well tested). So please send any bugs you notice to
\url{https://github.com/dcgerard/segtest/issues}.
}
\section{Parallel Computation}{


The \code{multi_lrt()} function supports parallel computing. It does
so through the \href{https://cran.r-project.org/package=future}{future}
package.

You first specify the evaluation plan with \code{\link[future]{plan}()}
from the \code{future} package. On a local machine, this is typically
just \code{future::plan(future::multisession, workers = nc)} where
\code{nc} is the number of workers you want. You can find the maximum
number of possible workers with \code{\link[future]{availableCores}()}.
You then run \code{multi_lrt()}, then shut down the workers with
\code{future::plan(future::sequential)}.
}

\examples{
\donttest{
## Assuming genotypes are known (typically a bad idea)
glist <- multidog_to_g(mout = ufit, type = "all_g", p1 = "indigocrisp", p2 = "sweetcrisp")
p1_1 <- glist$p1
p2_1 <- glist$p2
g_1 <- glist$g
multi_lrt(g = g_1, p1 = p1_1, p2 = p2_1)

## Using genotype likelihoods (typically a good idea)
glist <- multidog_to_g(mout = ufit, type = "all_gl", p1 = "indigocrisp", p2 = "sweetcrisp")
p1_2 <- glist$p1
p2_2 <- glist$p2
g_2 <- glist$g
multi_lrt(g = g_2, p1 = p1_2, p2 = p2_2)

## Offspring genotype likelihoods and parent genotypes known
multi_lrt(g = g_2, p1 = p1_1, p2 = p2_1)

## Offspring genotype likelihoods and no information on parent genotypes
multi_lrt(g = g_2, p1 = NULL, p2 = NULL)

## Parallel computing is supported through the future package
future::plan(future::multisession, workers = 2)
multi_lrt(g = g_2, p1 = p1_2, p2 = p2_2)
future::plan(future::sequential)
}

}
\seealso{
\itemize{
\item \code{\link[=lrt_men_g4]{lrt_men_g4()}} Single locus LRT for segregation distortion when genotypes are known.
\item \code{\link[=lrt_men_gl4]{lrt_men_gl4()}} Single locus LRT for segregation distortion when using genotype likelihoods.
}
}
\author{
David Gerard
}
