% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSegregation.R
\name{plotSegregation}
\alias{plotSegregation}
\title{Pedigree plot for segregation analysis}
\usage{
plotSegregation(
  x,
  affected = NULL,
  unknown = NULL,
  proband = NULL,
  carriers = NULL,
  noncarriers = NULL,
  cex = 1,
  margins = rep(1, 4),
  ...
)
}
\arguments{
\item{x}{A \code{\link[pedtools:ped]{pedtools::ped()}} object.}

\item{affected}{The affected pedigree members.}

\item{unknown}{Pedigree members with unknown affection status.}

\item{proband}{The ID label of the proband. This person must also be in both
\code{carriers} and \code{affected}.}

\item{carriers}{A character vector (or coercible to such), containing the ID
labels of pedigree members known to carry the variant in question.}

\item{noncarriers}{A character vector (or coercible to such), containing the
ID labels of pedigree members known \emph{not} to carry the variant in question.}

\item{cex, margins}{Arguments passed on to \code{\link[pedtools:plot.ped]{pedtools::plot.ped()}}.}

\item{...}{Optional plot parameters passed on to \code{\link[pedtools:plot.ped]{pedtools::plot.ped()}}.}
}
\description{
Plots a pedigree showing the segregation of a variant.
}
\examples{

x = nuclearPed(2)
plotSegregation(x, affected = 3:4, unknown = 1:2, proband = 3,
                carriers = 3:4, margins = c(1,3,1,1))

}
