% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutual.R
\name{mutual_total}
\alias{mutual_total}
\title{Calculate the total mutual information index}
\usage{
mutual_total(data, unit, group, within = NULL, weight = NULL, se = FALSE,
  n_bootstrap = 10)
}
\arguments{
\item{data}{A data frame.}

\item{unit}{A categorical variable or a vector of variables
contained in \code{data}. Defines the first dimension
over which segregation is computed.}

\item{group}{A categorical variable or a vector of variables
contained in \code{data}. Defines the second dimension
over which segregation is computed.}

\item{within}{A categorical variable or a vector of variables
contained in \code{data}. The variable(s) should be a superset of either
the \code{unit} or the \code{group} for the calculation to be meaningful.
If provided, segregation is
computed within the groups defined by the variable, and then averaged.
(Default \code{NULL})}

\item{weight}{Numeric. Only frequency weights are allowed.
(Default \code{NULL})}

\item{se}{If \code{TRUE}, standard errors are estimated via bootstrap.
(Default \code{FALSE})}

\item{n_bootstrap}{Number of bootstrap iterations. (Default \code{10})}
}
\value{
Returns a data frame with three rows. The column \code{est} contains
  in the first row total segregation. The second and third rows contain
  the lower and upper bounds of M, respectively.
  If \code{se} is set to \code{TRUE}, an additional column \code{se} contains
  the associated bootstrapped standard errors, and the column \code{est} contains
  bootstrapped estimates.
}
\description{
Returns the total segregation between \code{unit} and \code{group}.
}
\examples{
# calculate school racial segregation
mutual_total(schools00, "school", "race", weight="n") # => .425

# note that the definition of units and groups is arbitrary
mutual_total(schools00, "race", "school", weight="n") # => .425

# if units or groups are defined by a combination of variables,
# vectors of variable names can be provided -
# here there is no difference, because schools
# are nested within districts
mutual_total(schools00, "race", c("district", "school"),
             weight="n") # => .424

# estimate a standard error of M
mutual_total(schools00, "race", "school", weight="n", se=TRUE)

# estimate segregation within school districts
mutual_total(schools00, "race", "school",
             within="district", weight="n") # => .087

# estimate between-district racial segregation
mutual_total(schools00, "race", "district", weight="n") # => .338
# note that the sum of within-district and between-district
# segregation equals total school-race segregation;
# here, most segregation is between school districts
}
\references{
Henri Theil. 1971. Principles of Econometrics. New York: Wiley.

Ricardo Mora and Javier Ruiz-Castillo. 2011. "Entropy-based Segregation Indices". Sociological Methodology 41(1): 159–194.
}
