% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{apply_subsampling}
\alias{apply_subsampling}
\title{Internal function for subsampling}
\usage{
apply_subsampling(x, is_segclust, subsample, subsample_over, subsample_by)
}
\arguments{
\item{x}{data.frame to be subsampled}

\item{is_segclust}{TRUE or FALSE whether the function was called from
`segclust()` or `segmentation()`}

\item{subsample}{if FALSE disable subsampling}

\item{subsample_over}{maximum number of row accepted}

\item{subsample_by}{subsampling parameters}
}
\value{
a data.frame
}
\description{
if subsample = FALSE do nothing.
}
\details{
else if subsample_by is missing, subsample only 
if nrow(x) > subsample_over,
then it subsample with the minimum needed to get a
data.frame smaller than subsample_over

if subsample_by is provided, use it to subsample.
}
