% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pc_Sigma.R
\docType{methods}
\name{pc_Sigma}
\alias{pc_Sigma}
\alias{pc_Sigma-class}
\alias{pc_Sigma-methods}
\alias{pc_Sigma,simMGarch-method}
\title{Method to simulate correlated variables with change-points}
\usage{
pc_Sigma(object)

\S4method{pc_Sigma}{simMGarch}(object)
}
\arguments{
\item{object}{A \code{simMGarch} object.}
}
\description{
An S4 method that takes a \code{simMGarch} object and outputs simulated correlated time series with a piecewise constant covariance matrix. 
The correlations are generated as \eqn{\sigma_{i, i'} =  \rho^{|i-i'|}} with \eqn{\rho} taking values from \eqn{(-1,1)}. The exact variables that will contain a change-point are
randomly selected and controlled by \code{r} in the \code{simMGarch} object.
}
\examples{
cp=500
n=2000
pw.CCC.obj <- new("simMGarch")
pw.CCC.obj@changepoints=cp
pw.CCC.obj@n=n
pc_Sigma.obj <- pc_Sigma(pw.CCC.obj)
par(mfrow=c(1,2))
#requires corrplot library
#correlation matrix before the changepoint
#corrplot::corrplot.mixed(cor(pc_Sigma.obj@cor_errors[1:cp,]), order="hclust", tl.col="black")
#correlation matrix after the changepoint
#corrplot::corrplot.mixed(cor(pc_Sigma.obj@cor_errors[(cp+1):n,]), order="hclust", tl.col="black")
}
\references{
Cho, Haeran, and Karolos Korkas. "High-dimensional GARCH process segmentation with an application to Value-at-Risk." arXiv preprint arXiv:1706.01155 (2017).
}
