% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch.R
\name{fetch}
\alias{fetch}
\title{Fetch files}
\usage{
fetch(
  accessions,
  outputDir,
  overwrite = FALSE,
  keepSra = FALSE,
  prefetchCmd = "prefetch",
  prefetchArgs = NULL,
  fasterqdumpCmd = "fasterq-dump",
  fasterqdumpArgs = NULL,
  pigzCmd = "pigz",
  pigzArgs = NULL
)
}
\arguments{
\item{accessions}{Character vector of SRA run accessions.}

\item{outputDir}{String indicating the local directory in which to save the
files. Will be created if it doesn't exist.}

\item{overwrite}{Logical indicating whether to overwrite files that already
exist in \code{outputDir}.}

\item{keepSra}{Logical indicating whether to keep the ".sra" files.}

\item{prefetchCmd}{String indicating command for prefetch, which downloads
".sra" files.}

\item{prefetchArgs}{Character vector indicating arguments to pass to
prefetch.}

\item{fasterqdumpCmd}{String indicating command for fasterq-dump, which
uses ".sra" files to create ".fastq" files.}

\item{fasterqdumpArgs}{Character vector indicating arguments to pass to
fasterq-dump.}

\item{pigzCmd}{String indicating command for pigz, which converts ".fastq"
files to ".fastq.gz" files.}

\item{pigzArgs}{Character vector indicating arguments to pass to pigz.}
}
\value{
A list. As the function runs, it updates a tab-delimited log file in
\code{outputDir} called "progress.tsv".
}
\description{
This function uses the NCBI SRA Toolkit via \code{\link[=system2]{system2()}} to download files
from SRA and convert them to fastq.gz. To process files in parallel, register
a parallel backend, e.g., using \code{\link[doParallel:registerDoParallel]{doParallel::registerDoParallel()}}. Beware
that intermediate files created by fasterq-dump are uncompressed and could
require hundreds of gigabytes if files are processed in parallel.
}
\seealso{
\code{\link[=seeker]{seeker()}}, \code{\link[=fetchMetadata]{fetchMetadata()}}
}
