% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ct.R
\name{ct_mappings}
\alias{ct_mappings}
\title{Controlled terminology mappings}
\usage{
ct_mappings(ct_spec, from = ct_spec_vars("from"), to = ct_spec_vars("to"))
}
\arguments{
\item{ct_spec}{Controlled terminology specification as a
\link[tibble:tibble-package]{tibble}. Each row is for a mapped controlled term.
Controlled terms are expected in the column indicated by \code{to_col}.}

\item{from}{A character vector of column names indicating the variables
containing values to be recoded.}

\item{to}{A single string indicating the column whose values are to be
recoded into.}
}
\value{
A \link[tibble:tibble-package]{tibble} with two columns, \code{from} and
\code{to}, indicating the mapping of values, one per row.
}
\description{
\code{\link[=ct_mappings]{ct_mappings()}} takes a controlled terminology specification and returns the
mappings in the form of a \link[tibble:tibble-package]{tibble} in long format,
i.e. the recoding of values in the \code{from} column to the \code{to} column values,
one mapping per row.

The resulting mappings are unique, i.e. if \code{from} values are duplicated in
two \code{from} columns, the first column indicated in \code{from} takes precedence,
and only that mapping is retained in the controlled terminology map.
}
\keyword{internal}
