% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_dttm_fmt.R
\name{parse_dttm_fmt_}
\alias{parse_dttm_fmt_}
\alias{parse_dttm_fmt}
\title{Parse a date/time format}
\usage{
parse_dttm_fmt_(fmt, pattern)

parse_dttm_fmt(fmt, patterns = fmt_cmp())
}
\arguments{
\item{fmt}{A format string (scalar) to be parsed by \code{patterns}.}

\item{pattern, patterns}{A string (in the case of \code{pattern}), or a character
vector (in the case of \code{patterns}) of regexps for each of the individual
date/time components. Default value is that of \code{\link[=fmt_cmp]{fmt_cmp()}}. Use this function
if you plan on passing a different set of patterns.}
}
\value{
A \link[tibble:tibble-package]{tibble} of seven columns:
\itemize{
\item \code{fmt_c}: date/time format component. Values are either \code{"year"}, \code{"mon"},
\code{"mday"}, \code{"hour"}, \code{"min"}, \code{"sec"}, or \code{NA}.
\item \code{pat}: Regexp used to parse the date/time component.
\item \code{cap}: The captured substring from the format.
\item \code{start}: Start position in the format string for this capture.
\item \code{end}: End position in the format string for this capture.
\item \code{len}: Length of the capture (number of chars).
\item \code{ord}: Ordinal of this date/time component in the format string.
}

Each row is for either a date/time format component or a "delimiter" string
or pattern in-between format components.
}
\description{
\code{\link[=parse_dttm_fmt]{parse_dttm_fmt()}} parses a date/time formats, meaning it will try to parse
the components of the format \code{fmt} that refer to date/time components.
\code{\link[=parse_dttm_fmt_]{parse_dttm_fmt_()}} is similar to \code{\link[=parse_dttm_fmt]{parse_dttm_fmt()}} but is not vectorized
over \code{fmt}.
}
\keyword{internal}
