% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_dttm_fmt.R
\name{fmt_rg}
\alias{fmt_rg}
\title{Regexps for date/time components}
\usage{
fmt_rg(
  sec = "(\\\\b\\\\d|\\\\d{2})(\\\\.\\\\d*)?",
  min = "(\\\\b\\\\d|\\\\d{2})",
  hour = "\\\\d?\\\\d",
  mday = "\\\\b\\\\d|\\\\d{2}",
  mon = stringr::str_glue("\\\\d\\\\d|{months_abb_regex()}"),
  year = "(\\\\d{2})?\\\\d{2}",
  na = NULL,
  sec_na = na,
  min_na = na,
  hour_na = na,
  mday_na = na,
  mon_na = na,
  year_na = na
)
}
\arguments{
\item{sec}{Regexp for the second component.}

\item{min}{Regexp for the minute component.}

\item{hour}{Regexp for the hour component.}

\item{mday}{Regexp for the month day component.}

\item{mon}{Regexp for the month component.}

\item{year}{Regexp for the year component.}

\item{na}{Regexp of alternatives, useful to match special values coding for
missingness.}

\item{sec_na}{Same as \code{na} but specifically for the second component.}

\item{min_na}{Same as \code{na} but specifically for the minute component.}

\item{hour_na}{Same as \code{na} but specifically for the hour component.}

\item{mday_na}{Same as \code{na} but specifically for the month day component.}

\item{mon_na}{Same as \code{na} but specifically for the month component.}

\item{year_na}{Same as \code{na} but specifically for the year component.}
}
\value{
A named character vector of named patterns (regexps) for matching
each date/time component.
}
\description{
\code{\link[=fmt_rg]{fmt_rg()}} creates a character vector of named patterns to match individual
date/time components.
}
\keyword{internal}
