% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxkcut.R
\name{maxkcut}
\alias{maxkcut}
\title{Max-kCut Problem}
\usage{
maxkcut(B, K)
}
\arguments{
\item{B}{A (weighted) adjacency matrix}

\item{K}{An integer value, the minimum number of cuts in B}
}
\value{
Returns an object of class sqlp_input, containing the following:

\item{blk}{A matrix object describing the block diagonal structure of the SQLP data}
\item{At}{A matrix object containing constraint matrices for the primal-dual problem}
\item{C}{A matrix object containing the constant c matrices in the primal objective function}
\item{b}{A vector containing the right hand side of the equality constraints in the primal problem}
\item{OPTIONS}{A list object specifying the value of parbarrier}
}
\description{
\code{maxkcut} creates input for sqlp to solve the Max-kCut Problem -
given a graph object B, determine if a cut of at least size k exists.
}
\details{
Determines if a cut of at least size k exists for a graph B. Mathematical and implementation
details can be found in the vignette
}
\examples{
data(Bmaxkcut)

out <- maxkcut(Bmaxkcut,2)
blk <- out$blk
At <- out$At
C <- out$C
b <- out$b

}

