% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_smooth}
\alias{plot_smooth}
\title{Plot a smooth term from an sdmTMB model}
\usage{
plot_smooth(
  object,
  select = 1,
  n = 100,
  level = 0.95,
  ggplot = FALSE,
  rug = TRUE,
  return_data = FALSE
)
}
\arguments{
\item{object}{An \code{\link[=sdmTMB]{sdmTMB()}} model.}

\item{select}{The smoother term to plot.}

\item{n}{The number of equally spaced points to evaluate the smoother along.}

\item{level}{The confidence level.}

\item{ggplot}{Logical: use the \pkg{ggplot2} package?}

\item{rug}{Logical: add rug lines along the lower axis?}

\item{return_data}{Logical: return the predicted data instead of making a plot?}
}
\value{
A plot of a smoother term.
}
\description{
\strong{Deprecated: use \code{visreg::visreg()}. See \code{\link[=visreg_delta]{visreg_delta()}} for examples.}
}
\details{
Note:
\itemize{
\item Any numeric predictor is set to its mean
\item Any factor predictor is set to its first-level value
\item The time element (if present) is set to its minimum value
\item The x and y coordinates are set to their mean values
}
}
\examples{
if (inla_installed()) {
  d <- subset(pcod, year >= 2000 & density > 0)
  pcod_spde <- make_mesh(d, c("X", "Y"), cutoff = 30)
  m <- sdmTMB(
    data = d,
    formula = log(density) ~ s(depth_scaled) + s(year, k = 5),
    mesh = pcod_spde
  )
  plot_smooth(m)
}
}
