% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_bn.R
\name{gen_bn_learn}
\alias{gen_bn_learn}
\title{Generate synthetic data using BN learning.}
\usage{
gen_bn_learn(training_set, structure_learning_algorithm, evidences = NA)
}
\arguments{
\item{training_set}{A data frame of the training data. The generated data will
have the same size as the \code{training_set}.}

\item{structure_learning_algorithm}{A string of the structure learning algorithm
from \code{\link[bnlearn]{bnlearn}}.}

\item{evidences}{A string of evidence that is used to constraint the sampling of the
generated data.}
}
\value{
The output is a list of three objects: i) structure: the structure of the learned
BN indicating the relationship between the variables (a \code{\link[bnlearn:bn class]{bn-class}}
object); ii) fit_model: the fitted model showing the parameter distributions between
the variables ((a \code{\link[bnlearn:bn.fit]{bn.fit}}) object and iii) gen_data:
the generated synthetic data - if there is evidence to constraint the values
for some of the variables, the generated synthetic data will be sampled accroding
to the criteria.
}
\description{
\code{gen_bn_learn} uses Bayesian structure learning to simultaneously
learn the dependencies and the value of the parameters from
the input data.
}
\details{
The structure learning algorithms including: 'tabu' for Tabu search, 'hc' for
hill-climbing, 'pc.stable' for PC, 'gs' for Grow-Shrink, 'iamb' for Incremental
Association, 'fast.iamb' for Fast Incremental Association, 'inter.iamb' for
Interleaved Incremental Association, mmhc' for Max-Min Hill-Climbing,
'rsmax2' for Restricted Maximization, 'mmpc' for Max-Min Parents and Children,
'si.hiton.pc' for Semi-Interleaved HITON-PC, chow.liu' for Chow-Liu and 'aracne'
for An Algorithm for the Reconstruction of Gene Regulatory Networks in a Mammalian
Cellular Context.
}
\examples{
adult_data <- split_data(adult[1:100,], 70)
bn_learn1 <- gen_bn_learn(adult_data$training_set, "hc")
bn_evidence <- "age >=18 & capital_gain>=0 & capital_loss >=0 &
               hours_per_week>=0 & hours_per_week<=100"
bn_learn2 <- gen_bn_learn(adult_data$training_set, "hc", bn_evidence)

}
