\docType{class}
\name{dimVar-class}
\alias{dimVar-class}
\title{S4 class describing a dimVar-object}
\description{
An object of class \code{dimVar} holds all necessary
information about a single dimensional variable such as
original and standardized codes, the level-structure, the
hierarchical structure, codes that may be (temporarily)
removed from building the complete hierarchy (dups) and
their corresponding codes that correspond to these
duplicated codes.
}
\details{
\describe{ \item{slot \code{codesOriginal}:}{a character
vector (or NULL) holding original variable codes}
\item{slot \code{codesDefault}:}{a character vector (or
NULL) holding standardized codes} \item{slot
\code{codesMinimal}:}{a logical vector (or NULL) defining
if a code is required to build the complete hierarchy or
not (then the code is a (sub)total)} \item{slot
\code{vName}:}{character vector of length 1 (or NULL)
defining the variable name of the dimensional variable}
\item{slot \code{levels}:}{a numeric vector (or NULL)
defining the level structure. For each code the
corresponding level is listed with the grand-total always
having level==1} \item{slot \code{structure}:}{a numeric
vector (or NULL) with length of the total number of levels.
Each element shows how many digits the i-th level allocates
within the standardized codes (note: level 1 always
allocates exactly 1 digit in the standardized codes)}
\item{slot \code{dims}:}{a list (or NULL) defining the
hierarchical structure of the dimensional variable. Each
list-element is a character vector with elements available
in slot \code{codesDefault} and the first element always
being a (sub)total and the remaining elements being the
codes that contribute to the (sub)total} \item{slot
\code{dups}:}{character vector (or NULL) having showing
original codes that are duplicates in the hierarchy and can
temporarily removed when building a table with this
dimensional variable } \item{slot \code{dupsUp}:}{character
vector (or NULL) with original codes that are the
corresponding upper-levels to the codes that may be removed
because they are duplicates and that are listed in slot
\code{dups}} }
}
\note{
objects of class \code{dimVar} form the base for elements
in slot \code{dimInfo} of class \code{dimInfo}.
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}

